;<TaskBar Windows Switcher> program by G.Sandler, v1.1
;http://autoit-script.ru/index.php/topic,203.0.html

#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <EditConstants.au3>
#include <StaticConstants.au3>
#include <GUIToolbar.au3>
#include <WinAPI.au3>
#include <Array.au3>
#include <Misc.au3>
#Include <HotKey.au3>
#include <HotKeyInput.au3>

_Singleton("TaskBar_Windows_Switcher")

#Region Variables & Options
Opt("WinWaitDelay", 1)

Global $sConfig_File				= StringTrimRight(@ScriptFullPath, 3) & "ini"

Global $sLast_NextBack_Window 		= ""
Global $sLast_BackNext_Window 		= ""

Global $sDef_Exit_HT 				= 0x0A1A345 ;Ctrl + Shift + E
Global $sDef_SwitchBack_HT 			= 0x0825 ;Win + LEFT
Global $sDef_SwitchNext_HT 			= 0x0827 ;Win + RIGHT
Global $sDef_SwitchDblBack_HT 		= 0x0A25 ;Ctrl + Win + LEFT
Global $sDef_SwitchDblNext_HT 		= 0x0A27 ;Ctrl + Win + RIGHT
Global $sDef_SwitchNextBack_HT 		= 0x0826 ;Win + UP
Global $sDef_SwitchBackNext_HT 		= 0x0828 ;Win + DOWN
Global $sDef_SwitchFirst_HT 		= 0x0A28 ;Ctrl + Win + DOWN
Global $sDef_SwitchLast_HT 			= 0x0A26 ;Ctrl + Win + UP
Global $sDef_SwitchAsAltTab_HT 		= 0x0409 ;Alt + TAB

Global $sExit_HT 					= IniRead($sConfig_File, "HotKeys", "Exit", $sDef_Exit_HT)
Global $sSwitchBack_HT 				= IniRead($sConfig_File, "HotKeys", "SwitchBack", $sDef_SwitchBack_HT)
Global $sSwitchNext_HT 				= IniRead($sConfig_File, "HotKeys", "SwitchNext", $sDef_SwitchNext_HT)
Global $sSwitchDblBack_HT 			= IniRead($sConfig_File, "HotKeys", "SwitchDblBack", $sDef_SwitchDblBack_HT)
Global $sSwitchDblNext_HT 			= IniRead($sConfig_File, "HotKeys", "SwitchDblNext", $sDef_SwitchDblNext_HT)
Global $sSwitchNextBack_HT 			= IniRead($sConfig_File, "HotKeys", "SwitchNextBack", $sDef_SwitchNextBack_HT)
Global $sSwitchBackNext_HT 			= IniRead($sConfig_File, "HotKeys", "SwitchBackNext", $sDef_SwitchBackNext_HT)
Global $sSwitchFirst_HT 			= IniRead($sConfig_File, "HotKeys", "SwitchFirst", $sDef_SwitchFirst_HT)
Global $sSwitchLast_HT 				= IniRead($sConfig_File, "HotKeys", "SwitchLast", $sDef_SwitchLast_HT)
Global $sSwitchAsAltTab_HT 			= IniRead($sConfig_File, "HotKeys", "SwitchAsAltTab", $sDef_SwitchAsAltTab_HT)
#EndRegion Variables & Options

_SetHotKeys_Proc()

While 1
	Sleep(1000)
WEnd

Func _SetHotKeys_Proc()
	Local $iGUI_Width = 350, $iGUI_Height = 470
	
	Local $hGUI = GUICreate('TaskBar Windows Switcher - HotKeys', $iGUI_Width, $iGUI_Height)
	GUISetFont(8.5, 400, 0, 'Tahoma', $hGUI)
	
	GUICtrlCreateLabel('Please set HotKeys to control the <TaskBar Windows Switcher>' & @CRLF & _
		'(Click on Input box and hold a combination of keys)', 0, 10, 350, 30, $es_center)
	GUICtrlSetFont(-1, 8, 800)
	
	Local $iTop = 50, $iLeft = 190, $nHotKey_CtrlID
	
	Local $aLabels = StringSplit( _
		"Exit the program|Switch to previous window|Switch to next window|Switch to previous window twice|" & _
		"Switch to next window twice|Switch to *prev.* & next window|Switch to *next* & prev. window|Switch to first window|" & _
		"Switch to last window|Alt + Tab alternative switch", "|")
	
	Local $aHK_Vars = StringSplit( _
		"Exit|SwitchBack|SwitchNext|SwitchDblBack|SwitchDblNext|SwitchNextBack|" & _
		"SwitchBackNext|SwitchFirst|SwitchLast|SwitchAsAltTab", "|")
	
	For $i = 1 To $aLabels[0]
		GUICtrlCreateLabel($aLabels[$i] & ':', 10, $iTop + 3, $iLeft - 5, 15, BitOr($GUI_SS_DEFAULT_LABEL, $SS_NOPREFIX))
		
		$nHotKey_CtrlID = _GUICtrlCreateHotKeyInput(Eval("s" & $aHK_Vars[$i] & "_HT"), _
			$iLeft, $iTop, $iGUI_Width - $iLeft - 10, 20, -1, BitOR($WS_EX_CLIENTEDGE, $WS_EX_STATICEDGE), "+")
		
		Assign("HotkeyInput" & $i, $nHotKey_CtrlID)
		
		$iTop += 40
	Next
	
	_KeyLock(0x062E) ; Lock CTRL-ALT-DEL for Hotkey Input control, but not for Windows
	
	Local $Ok_Button = GUICtrlCreateButton('OK', 10, 440, 80, 20)
	Local $Cancel_Button = GUICtrlCreateButton('Cancel', 110, 440, 80, 20)
	Local $SetDefaults_Button = GUICtrlCreateButton('Set Defaults', $iGUI_Width - 90, 440, 80, 20)
	
	GUICtrlSetState($Ok_Button, BitOR($GUI_DEFBUTTON, $GUI_FOCUS))
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $Cancel_Button
				Exit
			Case $Ok_Button
				Local $nHotKey
				Local $aHK_Vars = StringSplit( _
					"Exit|SwitchBack|SwitchNext|SwitchDblBack|SwitchDblNext|SwitchNextBack|" & _
					"SwitchBackNext|SwitchFirst|SwitchLast|SwitchAsAltTab", "|")
				
				For $i = 1 To $aHK_Vars[0]
					$nHotKey = _GUICtrlReadHotKeyInput(Eval("HotkeyInput" & $i))
					
					If $nHotKey > 0 Then
						Assign("s" & $aHK_Vars[$i] & "_HT", $nHotKey)
						_HotKeyAssign($nHotKey, "_SwitchTaskBarWindow_Proc", BitOR($HK_FLAG_DEFAULT, $HK_FLAG_EXTENDEDCALL))
					;Else
					;	$nHotKey = Eval("sDef_" & $aHK_Vars[$i] & "_HT")
					EndIf
					
					IniWrite($sConfig_File, "HotKeys", $aHK_Vars[$i], $nHotKey)
				Next
				
				_HotKeyAssign($sExit_HT, "_Exit")
				
				GUIDelete($hGUI)
				ExitLoop
			Case $SetDefaults_Button
				If MsgBox(52, "Attention", "Are you sure, set default HotKeys?", 0, $hGUI) <> 6 Then ContinueLoop
				
				Local $nHotKey
				Local $aHK_Vars = StringSplit( _
					"Exit|SwitchBack|SwitchNext|SwitchDblBack|SwitchDblNext|SwitchNextBack|" & _
					"SwitchBackNext|SwitchFirst|SwitchLast|SwitchAsAltTab", "|")
				
				For $i = 1 To $aHK_Vars[0]
					$nHotKey = Eval("sDef_" & $aHK_Vars[$i] & "_HT")
					Assign("s" & $aHK_Vars[$i] & "_HT", $nHotKey)
					_GUICtrlSetHotKeyInput(Eval("HotkeyInput" & $i), $nHotKey)
				Next
		EndSwitch
	WEnd
EndFunc

Func _SwitchTaskBarWindow_Proc($iKey)
	Local $HotKeyPressed = "0x" & Hex($iKey, 4)
	_HotKeyAssign($HotKeyPressed)
	
	Local $sActivate_Window = "", $hParent_Active_Wnd = _WinAPI_GetAncestor(WinGetHandle(""), $GA_ROOTOWNER)
	Local $aTaskBarWindows = _WinListTaskBarWindowsEx(Number($HotKeyPressed <> $sSwitchAsAltTab_HT))
	
	If @error Then Return _HotKeyAssign($HotKeyPressed, "_SwitchTaskBarWindow_Proc", BitOR($HK_FLAG_DEFAULT, $HK_FLAG_EXTENDEDCALL))
	
	For $i = 1 To $aTaskBarWindows[0][0]
		If WinActive($aTaskBarWindows[$i][0]) Or $aTaskBarWindows[$i][0] = $hParent_Active_Wnd Then
			Switch $HotKeyPressed
				Case $sSwitchBack_HT, $sSwitchAsAltTab_HT ;  (1-  )
					If $i = 1 Then $i = $aTaskBarWindows[0][0] + 1
					$sActivate_Window = $aTaskBarWindows[$i - 1][0]
				Case $sSwitchNext_HT, $sSwitchAsAltTab_HT ;  (1-  )
					If $i = $aTaskBarWindows[0][0] Then $i = 0
					$sActivate_Window = $aTaskBarWindows[$i + 1][0]
				Case $sSwitchDblBack_HT ;  (2-  )
					If $i = 1 Then $i = $aTaskBarWindows[0][0] + 1
					If $i = 2 Then $i = $aTaskBarWindows[0][0] + 2
					$sActivate_Window = $aTaskBarWindows[$i - 2][0]
				Case $sSwitchDblNext_HT	;  (2-  )
					If $i = $aTaskBarWindows[0][0] Then $i = 0
					If $i + 2 <= $aTaskBarWindows[0][0] Then $sActivate_Window = $aTaskBarWindows[$i + 2][0]
				Case $sSwitchNextBack_HT ; <>  
					If $sLast_NextBack_Window <> $aTaskBarWindows[$i][0] Then $sLast_NextBack_Window = ""
					
					If $sLast_NextBack_Window = "" Then
						If $i = $aTaskBarWindows[0][0] Then $i = 0
						$sActivate_Window = $aTaskBarWindows[$i + 1][0]
						$sLast_NextBack_Window = $sActivate_Window
					Else
						If $i = 1 Then $i = $aTaskBarWindows[0][0] + 1
						$sActivate_Window = $aTaskBarWindows[$i - 1][0]
						$sLast_NextBack_Window = ""
					EndIf
				Case $sSwitchBackNext_HT ; <>  
					If $sLast_BackNext_Window <> $aTaskBarWindows[$i][0] Then $sLast_BackNext_Window = ""
					
					If $sLast_BackNext_Window = "" Then
						If $i = 1 Then $i = $aTaskBarWindows[0][0] + 1
						$sActivate_Window = $aTaskBarWindows[$i - 1][0]
						$sLast_BackNext_Window = $sActivate_Window
					Else
						If $i = $aTaskBarWindows[0][0] Then $i = 0
						$sActivate_Window = $aTaskBarWindows[$i + 1][0]
						$sLast_BackNext_Window = ""
					EndIf
				Case $sSwitchFirst_HT, $sSwitchLast_HT
					$sActivate_Window = ""
			EndSwitch
			
			ExitLoop
		EndIf
	Next
	
	;   ...
	If $sActivate_Window = "" Then
		Switch $HotKeyPressed
			Case $sSwitchBack_HT, $sSwitchLast_HT
				;  
				$sActivate_Window = $aTaskBarWindows[$aTaskBarWindows[0][0]][0]
			Case Else
				;  
				$sActivate_Window = $aTaskBarWindows[1][0]
		EndSwitch
	EndIf
	
	WinActivate($sActivate_Window)
	_HotKeyAssign($HotKeyPressed, "_SwitchTaskBarWindow_Proc", BitOR($HK_FLAG_DEFAULT, $HK_FLAG_EXTENDEDCALL))
EndFunc

Func _WinListTaskBarWindowsEx($iListSort=1)
	Local $hToolbar = ControlGetHandle("[CLASS:Shell_TrayWnd]", "", "ToolbarWindow323")
	If @error Then $hToolbar = ControlGetHandle("[CLASS:Shell_TrayWnd]", "", "ToolbarWindow322")
	If @error Then Return SetError(1, 0, 0)
	
	Local $aWinList = WinList()
	Local $aRet_List[$aWinList[0][0] + 1][2], $iToolbarButtonIndex
	
	For $i = 1 To $aWinList[0][0] Step 1
		If Not BitAND(WinGetState($aWinList[$i][1]), 2) Then ContinueLoop
		
		$iToolbarButtonIndex = _WinAPI_FindToolbarButton($aWinList[$i][1], $hToolbar)
		
		If $iToolbarButtonIndex > 0 Then
			$aRet_List[0][0] += 1
			$aRet_List[$aRet_List[0][0]][0] = $aWinList[$i][1]
			$aRet_List[$aRet_List[0][0]][1] = $iToolbarButtonIndex
		EndIf
	Next
	
	If $aRet_List[0][0] = 0 Then Return SetError(2, 0, 0)
	
	ReDim $aRet_List[$aRet_List[0][0] + 1][2]
	If $iListSort Then _ArraySort($aRet_List, 0, 1, $aRet_List[0][0], 1)
	
	Return $aRet_List
EndFunc

Func _WinAPI_FindWindowEx($hParent, $hChild, $sClass, $sWindow)
	; must create structs and use ptrs to account for passing a true NULL as classname or window title
	; simply using "wstr" and "" does NOT work
	Local $sStruct1, $sStruct2
	
	If $sClass = "" Then
		$sClass = 0
	Else
		$sStruct1 = DllStructCreate("wchar[256]")
		DllStructSetData($sStruct1, 1, $sClass)
		$sClass = DllStructGetPtr($sStruct1)
	EndIf
	
	If $sWindow = "" Then
		$sWindow = 0
	Else
		$sStruct2 = DllStructCreate("wchar[256]")
		DllStructSetData($sStruct2, 1, $sWindow)
		$sWindow = DllStructGetPtr($sStruct2)
	EndIf
	
	Local $aRet = DllCall("user32.dll", "hwnd", "FindWindowExW", "hwnd", $hParent, "hwnd", $hChild, "ptr", $sClass, "ptr", $sWindow)
	
	$sStruct1 = 0
	$sStruct2 = 0
	
	Return $aRet[0]
EndFunc

Func _WinAPI_FindToolbarButton($hWnd, $hTB)
	Local $iReturn = -1, $iPID, $hProcess, $sStruct = DllStructCreate("ptr")
	
	; open process owning toolbar control
	_WinAPI_GetWindowThreadProcessId($hTB, $iPID)
	
	$hProcess = _WinAPI_OpenProcess(0x410, False, $iPID)
	
	If $hProcess Then
		Local $iCount = _GUICtrlToolbar_ButtonCount($hTB)
		
		For $i = 0 To $iCount - 1
			Local $iID = _GUICtrlToolbar_IndexToCommand($hTB, $i)
			
			; button param is ptr to owner's window handle, stored in target process's memory space
			Local $dwData = _GUICtrlToolbar_GetButtonParam($hTB, $iID)
			
			; read the window handle from the explorer process
			Local $aRet = DllCall("kernel32.dll", "int", "ReadProcessMemory", "ptr", _
					$hProcess, "ptr", $dwData, "ptr", DllStructGetPtr($sStruct), "uint", 4, "uint*", 0)
			
			If $aRet[5] Then
				If $hWnd = DllStructGetData($sStruct, 1) Then
					$iReturn = $i
					ExitLoop
				EndIf
			EndIf
		Next
		
		_WinAPI_CloseHandle($hProcess)
	EndIf
	
	Return $iReturn
EndFunc

Func _Exit()
	Exit
EndFunc
